#include <htc.h>
#define _XTAL_FREQ 4000000
__CONFIG(FOSC_INTOSC & WDTE_OFF & PWRTE_OFF & MCLRE_OFF & BOREN_OFF & CP_OFF & CPD_OFF & CLKOUTEN_OFF & IESO_OFF & FCMEN_OFF);
__CONFIG(WRT_OFF & PLLEN_OFF & PLLEN_OFF & BORV_19 & LVP_OFF);
__IDLOC(0000);
typedef unsigned char UInt8;
typedef unsigned short UInt16;
typedef unsigned long UInt32;
typedef signed char Int8;
typedef signed short Int16;
typedef signed long Int32;


static UInt32 pressesSinceBattChange = 0;

void led(void){		//half a ms or so

	TMR2ON = 1;					//timer2 on
	TMR2 = 0;					//reset timer2
	CCP1CON |= 0b00001100;		//PWM on
	__delay_us(500);
	CCP1CON &=~ 0b00001111;		//PWM off
	TMR2ON = 0;					//timer2 off
}


UInt8 eeRead(UInt8 addr){


	EECON1 = 0b00000000;	//read data
	EEADRL = addr;
	EECON1bits.RD = 1;		//do it
	return EEDATL;
}

void sendByte(UInt8 b){	//manchester

	UInt8 i = 8;

	do{
		led();
		if(b & 0x80) __delay_us(1500);
		else __delay_us(1000);
		b <<= 1;

	}while(--i);
}

void eeWrite(UInt8 addr, UInt8 data){

	EECON1= 0b00000100;	//write data
	EEADRL = addr;
	EEDATL = data;
	INTCONbits.GIE = 0;
	EECON2 = 0x55;
	EECON2 = 0xAA;
	EECON1bits.WR = 1;
	INTCONbits.GIE = 1;
	while(EECON1bits.WR);
}


UInt16 measureVoltage(void){	//return in centivolts

	UInt8 i;
	UInt32 t = 0;

	FVRCON	= 0b11000001;		//output 1.024 V to ADC
	ADCON1	= 0b11100000;		//ADC VREF is VDD
	ADCON0	= 0b01111101;		//ADC on, FVR as input
	
	while(!FVRRDY);

	for(i = 0; i < 16; i++){	//sample 16x, extra resolution bit :)
		GO = 1;
		while(GO);
		t += ADRES;
	}
	
	t = (0x199998UL + (t >> 1)) / t;	//rounding is nice

	FVRCON	= 0b00000000;		//FVR off
	ADCON0	= 0b00000000;		//ADC off

	return t;
}

void sendButton(UInt8 btn){

	UInt8 i, t, j, crc = 0;
	UInt8 packet[12];
	UInt16 v;

	//read, increment, stick into packet, and write back "total presses" value
	for(i = 0; i < 4; i++) packet[i] = eeRead(i);
	for(i = 0; i < 4; i++) if(++packet[i]) break;
	for(i = 0; i < 4; i++) eeWrite(i, packet[i]);

	//stick number of presses since last batt change into packet
	packet[4] = pressesSinceBattChange;
	packet[5] = pressesSinceBattChange >> 8;
	packet[6] = pressesSinceBattChange >> 16;
	packet[7] = pressesSinceBattChange >> 24;
	pressesSinceBattChange++;

	//stick pattery voltage into packet
	v = measureVoltage();
	packet[8] = v;
	packet[9] = v >> 8;

	//stick pressed button into packet
	packet[10] = btn;

	//calculate CRC and stick it into packet
	for(i = 0; i < sizeof(packet) - 1; i++){
		
		t = packet[i];
		for(j = 0; j < 8; j++, t <<= 1){

			crc = (crc << 1) ^ (((t ^ crc) & 0x80) ? 0x83 : 0);
		}
	}
	packet[sizeof(packet) - 1] = crc;

	//send prologue
	sendByte(0xFF);

	//send header
	sendByte(0x05);
	
	//send data
	for(i = 0; i < sizeof(packet); i++) sendByte(packet[i]);

	//send footer as needed
	sendByte(0xFF);
}

void log(UInt8 a){

	static UInt16 addr = 0;

	if(addr < 0x100) eeWrite(addr++, a);
}

void main(void){

	OSCCON		= 0b11101000;	// 4MHz
	OPTION_REG	= 0b00001000;	// pullups on, TMR0 @ Fosc/4
	ANSELA		= 0b00000000;	// no analog pins
	PORTA		= 0b00000000;	// output low
	WPUA		= 0b00011111;	// pullups for buttons
	TRISA		= 0b11011111;	// RA5 out, others in
	VREGCON		= 0b00000010;	// lower power sleep please
	INTCON		= 0b00000000;	// ints off and blocked
	APFCON		= 0b00000001;	// CCP1 on RA5

	CCP1CON		= 0b00000000;	//prepare for PWM
	T2CON		= 0b00000000;	//prepare timer2
	CCPR1L      = 13;
	PR2			= 25;

	__delay_ms(300);

	while(1){

		UInt8 t, n, btn;

		//wait for button press
		OSCCON	= 0b00000011;			//switch to 31 KHZ clock
		while(1){
			
			t = PORTA & 0x1F;
			while((n = (PORTA & 0x1F)) == t);
			btn = (t ^ n) & t;						//what changed and is now low (btn down)
			if(btn && !(btn & (btn - 1))) break;	//nothing? or more than one bit then we have a button press
			t = n;
		}

		//ramp up the oscillator
		OSCCON		= 0b11101000;	// 4MHz
	
		//figure out which button it is
		t = 0;
		while(btn >>= 1) t++;
		btn = t;

		//wait for oscillator to be ready
		while(!HFIOFL);

		//send the code forever
		t = 10;	//initial delay before autorepeat
		do{
			
			if(t == 10 || t == 0) sendButton(btn);
			if(t) t--;
			if((PORTA & 0x1F) != n) break;
			__delay_ms(50);
		}while(1);
	}
}